      SUBROUTINE WRITE_PX(IOUT,ARRAY,ND1,N1,N2,SUPPRESS_NULLS,*)
C======================================================================C
C                                                                      C
C  WRITE_PX                                                            C
C                                                                      C
C  *** NOTE: this routine must be compiled with /NOOPTIMIZE ***        C
C                                                                      C
C  Writes the printronix bitmap stored in ARRAY(ND1,N1) to the FORTRAN C
C  unit IOUT in printronix format.  ARRAY contains N2 lines of N1      C
C  bytes which form a bit map image in printronix format with 6 bits   C
C  per byte. For the printronix N1 is a maximum of 131 which implies   C
C  a total of 786 dots per line (IY = 0 to 785).  The x-axis runs      C
C  vertically down the printronix page with IX ranging from 0 to N2-1. C
C  The y-axis runs horizontally across the page with IY ranging from   C
C  0 to N1*6-1. The origin of this coordinate system is at the top     C
C  left hand corner of the page, i.e. the 1'st bit (low order bit) of  C
C  ARRAY(1,1).  0 <= IX <= N2-1; 0 <= IY <= N1*6-1.  The dot location  C
C  (IX,IY) is represented in the array by the IMOD(IY,6)+1'th bit of   C
C  the array location ARRAY(IY/6+1,IX+1).                              C
C                                                                      C
C  Eg. (0,0) is the 1st bit of ARRAY(1,1), and (N2-1,N1*6-1) is the    C
C  6th bit of ARRAY(N1,N2).                                            C
C                                                                      C
C  If SUPPRESS_NULLS=.TRUE. then the blank dot lines at the end of     C
C  the bitmap will not be printed.                                     C
C                                                                      C
C   Input  Parameters: IOUT (I*4); ARRAY(ND1,N2) (L*1);                C
C                      ND1,N1,N2 (I*4); SUPPRESS_NULLS (L*4).          C
C                                                                      C
C   Written by Arthur Haynes, TRIUMF U.B.C., April 8, 1982.            C
C                                                                      C
C     Modified July 12/83 by F. Jones for unformatted output:          C
C     If IOUT is assigned to a file which is to be printed later,      C
C     processing is speeded up considerably by unformatted writes      C
C     into the file.  To take advantage of this, open unit IOUT        C
C     with FORM='UNFORMATTED' and CARRIAGECONTROL='LIST'.              C
C     The logical variable FMTED in COMMON/SPOOL/ should be            C
C     set to .FALSE. by the calling program.  The default for          C
C     FMTED is .TRUE. (formatted output as before).                    C
C                                                                      C
C  Modified Jan 19/88 by F. Jones:  This routine has been re-written   C
C    to reflect a change in internal bitmap storage from Printronix    C
C    format (6 significant bits per byte) to HP Laserjet format        C
C    (8 significant bits per byte).  The functions LSWAP and MVBITS    C
C    are used to unpack groups of 3 bytes from the internal bitmap     C
C    into groups of 4 bytes to be written to the plot file.            C
C    Also, trailing zeros are now suppressed by default and the flag   C
C    SUPPRESS_NULLS is ignored.                                        C
C                                                                      C
C  modified by J.Chuma, 19Mar97 for g77
C   LOGICAL*1 changed to BYTE
C======================================================================C
      BYTE ARRAY(ND1,N2)
      LOGICAL SUPPRESS_NULLS

      COMMON/SPOOL/FMTED
      LOGICAL FMTED
      COMMON /HARDCOPYRANGE2/ XMINH2,XMAXH2,YMINH2,YMAXH2

      BYTE LINE(132)
C  Modified by J.Chuma, 23Apr97 for Absoft f77  changed X' to Z'
      BYTE CTRL_E/Z'05'/

C Buffers for conversion from HP Laserjet to Printronix format:
      INTEGER*4 IS,ID
      BYTE ISL(4),IDL(4)
      EQUIVALENCE(IS,ISL),(ID,IDL)
C
C Bit swap function:
      BYTE LSWAP
C
C Find extent of bitmap data:
      IBITS=INT(YMAXH2)+1
      JBITS=INT(XMAXH2)+1
      IEND_MAX=IBITS/8
      IF(MOD(IBITS,8).NE.0)IEND_MAX=IEND_MAX+1
      IEND_MAX=MIN(IEND_MAX,99)
      JEND_MAX=MIN(JBITS,N2)
      DO JEND=JEND_MAX,1,-1
        DO I=1,IEND_MAX
          IF(ARRAY(I,JEND).NE.0)GO TO 70
        ENDDO
      ENDDO
      JEND=1

70    DO J=1,JEND
C Find number of bytes (max 99) to get from current line:
        DO IEND=IEND_MAX,1,-1
          IF(ARRAY(IEND,J).NE.0)GO TO 80
        ENDDO
        IEND=0
80      NG3=IEND/3      !Number of groups of 3 bytes to get
        IF(MOD(IEND,3).NE.0)NG3=NG3+1
        IF(NG3.EQ.0)GO TO 120
C
C Initialize base locations in input & output arrays:
        ILOCI=1
        ILOCO=1
        IG3=1      !Group #
C
C Get next group of 3 bytes from bitmap, reversing bit order
100     DO I=1,3
          ISL(I)=LSWAP(ARRAY(ILOCI+I-1,J))
        ENDDO
C Expand the 3 bytes into 4 for Printronix format:
        CALL MVBITS(IS,0,6,ID,0)
        CALL MVBITS(IS,6,6,ID,8)
        CALL MVBITS(IS,12,6,ID,16)
        CALL MVBITS(IS,18,6,ID,24)
C Move the 4 bytes into the output buffer
        DO I=1,4
          IF(IDL(I).LT.32)IDL(I)=IDL(I)+64
          LINE(ILOCO+I-1)=IDL(I)
        ENDDO
        IF(IG3.EQ.NG3)GO TO 120      !Last group
C Update locations:
        IG3=IG3+1
        ILOCI=ILOCI+3
        ILOCO=ILOCO+4
        GO TO 100
C Send the output buffer:
120     ILAST=MIN(NG3*4+1,132)
        LINE(ILAST)=CTRL_E
        IF(FMTED)THEN
          WRITE(IOUT,160,ERR=999)(LINE(I),I=1,ILAST)
        ELSE
          WRITE(IOUT,ERR=999)(LINE(I),I=1,ILAST)
        ENDIF
      ENDDO
160   FORMAT(132A1)
      RETURN

999   WRITE(*,*)'Error writing Printronix plot file on unit',IOUT
      IDUM = NARGSI(0)
      CALL PUT_FORMSG
      RETURN 1
      END
